#!/usr/bin/env python
# coding: utf-8
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

from collections import defaultdict

ErrorlogPath = 'mapper_check/error_log.txt'


class ErrorlogPrinter:
    def __init__(self):
        self.error_ruleinfo_table = defaultdict(self.default_error)
        self.error_ruleinfo_table['2-1'] = '被引用数据来源检查失败'
        self.error_ruleinfo_table['2-2'] = '数据引用位置检查失败'
        self.error_ruleinfo_table['2-3'] = 'URI中的动态槽位号格式检查失败'
        self.error_ruleinfo_table['2-4'] = 'Uri引用有效性检查失败'
        self.error_ruleinfo_table['2-5'] = 'ReqBody引用有效性检查失败'
        self.error_ruleinfo_table['2-6'] = 'Query引用有效性检查失败'
        self.error_ruleinfo_table['2-7'] = 'PrcessingFlow引用有效性检查失败'
        self.error_ruleinfo_table['2-8'] = 'Statements引用有效性检查失败'
        self.error_ruleinfo_table['2-9'] = 'Context引用有效性检查失败'
        self.error_ruleinfo_table['2-10'] = '全局变量有效性检查失败'
        self.error_ruleinfo_table['3-1'] = 'Uri合法性校验存在性检查失败'
        self.error_ruleinfo_table['3-2'] = '@odata.context属性格式检查失败'
        self.error_ruleinfo_table['3-3'] = 'URI重复性检查失败'
        self.error_ruleinfo_table['3-4'] = 'URI中的动态槽位号合法性检查失败'
        self.error_ruleinfo_table['3-5'] = '厂商定制正确性检查失败'
        self.error_ruleinfo_table['4-1'] = '被调用的脚本存在性检查失败'
        self.error_ruleinfo_table['4-2'] = '被调用的插件存在性检查失败'
        self.error_ruleinfo_table['4-3'] = '被调用的插件函数存在性检查失败'
        self.error_ruleinfo_table['4-4'] = '被调用的插件函数入参个数检查失败'

    def get_relpath_under_rackmount(self, path):
        start_index = path.find('interface_config')
        if start_index != -1:
            return path[start_index:]
        else:
            return ''

    def default_error(self):
        return '未定义的Rule序号'
    
    def print_errorlog(self, rule_id, *error_info):
        self.print_errorlog2file(rule_id, *error_info)
        self.print_errorlog2tmn(rule_id, *error_info)

    def print_errorlog2file(self, rule_id, *error_info):
        error_ruleinfo = ''
        if (rule_id == '2-5' and len(error_info) > 5):
            error_ruleinfo = '{}, 引用了未定义的ReqBody成员:{}'.format(self.error_ruleinfo_table[rule_id], error_info[5])
        elif (rule_id == '2-7' and len(error_info) > 5):
            error_ruleinfo = '{}, {}'.format(self.error_ruleinfo_table[rule_id], error_info[5])
        else:
            error_ruleinfo = self.error_ruleinfo_table[rule_id]
        errorlog_file = open(ErrorlogPath, 'a+')
        rtl_path = self.get_relpath_under_rackmount(error_info[0])
        print('=============reference errors found in file:', rtl_path, file=errorlog_file)
        print('[Rule {}]: {}, 错误值:{}, 错误位置: URI:{}, Type:{}, location:{}'.format(
            rule_id, 
            error_ruleinfo,
            error_info[1], 
            error_info[2], 
            error_info[3], 
            error_info[4]), 
            file = errorlog_file)
        errorlog_file.close()

    def print_errorlog2tmn(self, rule_id, *error_info):
        error_ruleinfo = ''
        if (rule_id == '2-5' and len(error_info) > 5):
            error_ruleinfo = '{}, 引用了未定义的ReqBody成员:{}'.format(self.error_ruleinfo_table[rule_id], error_info[5])
        elif (rule_id == '2-7' and len(error_info) > 5):
            error_ruleinfo = '{}, {}'.format(self.error_ruleinfo_table[rule_id], error_info[5])
        else:
            error_ruleinfo = self.error_ruleinfo_table[rule_id]
        rtl_path = self.get_relpath_under_rackmount(error_info[0])
        print('=============reference errors found in file:', error_info[0])
        print('[Rule {}]: {}, 错误值:{}, 错误位置: URI:{}, Type:{}, location:{}'.format(
            rule_id, 
            error_ruleinfo,
            error_info[1], 
            error_info[2], 
            error_info[3], 
            error_info[4]))