-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local RSP_LOGIN_BY_USER = 0x0
local RSP_LOGIN_FAILED = 0x2
local RSP_LOGOUT_BY_CERT = 0x3
local result = {rsp = {Session = '', stateCode = 0, token = ''}, header = {}}
local cookie = ReqHeader['cookie']
local logoutbycert

if cookie then
    logoutbycert = cookie:match('.*logoutbycert=(.*)')
end
result.rsp.stateCode = RSP_LOGIN_BY_USER
local mutual_state = ProcessingFlow[1].Destination.Enabled
if mutual_state == nil then
    result.rsp.stateCode = RSP_LOGIN_FAILED
    return result
end
if mutual_state then
    if logoutbycert ~= nil then
        return {rsp = {stateCode = RSP_LOGOUT_BY_CERT, Session = '', token = ''}, header = {}}
    end
    result = Input
end
return result