-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local json_body = ProcessingFlow[1].Destination.JsonBody
if not json_body or #json_body == 0 then
    return json_body
end

local input = cjson.decode(json_body)
local data = ProcessingFlow[2].Destination.Data
local sensitive_properties = {}
local tmp
local job_type = ProcessingFlow[1].Destination.JobType
for _, job in ipairs(data or {}) do
    tmp = cjson.decode(job)
    if tmp.JobType ~= job_type then
        goto continue
    end
    if tmp.PayloadParams and tmp.PayloadParams.SensitiveProperties then
        for _, value in ipairs(tmp.PayloadParams.SensitiveProperties) do
            sensitive_properties[value] = true
        end
    end
    ::continue::
end

if next(sensitive_properties) == nil then
    return json_body
end

local function process_sensitive_data(_input, _sensitive_properties)
    for key, value in pairs(_input) do
        if type(value) == "table" then
            process_sensitive_data(value, _sensitive_properties)
            goto continue
        end
        if _sensitive_properties[key] then
            _input[key] = '******'
        end
        ::continue::
    end
end

process_sensitive_data(input, sensitive_properties)

return cjson.encode(input)
