-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local role_table = {
    ['NoAccess'] = 0,
    ['CommonUser'] = 2,
    ['Operator'] = 3,
    ['Administrator'] = 4,
    ['CustomRole1'] = 5,
    ['CustomRole2'] = 6,
    ['CustomRole3'] = 7,
    ['CustomRole4'] = 8,
    [''] = -1
}

local role_ids = {}

for i = 1, 5 do
    local role_id = (ReqBody.LdapGroup[i] or {}).RoleID or ''
    role_ids[i] = role_table[role_id]
end

return role_ids