-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local old_groups = ProcessingFlow[3].Destination.Groups
local is_group_exist = {false, false, false, false, false}
for _, group in ipairs(old_groups) do
    -- 示例: 从/bmc/kepler/AccountService/RemoteGroups/LDAP1_2中获取LDAP后的1和2
    local controller_id, group_id = string.match(group, '.*/LDAP(%d+)_(%d+)')
    if controller_id == Uri.controllerid then
        is_group_exist[tonumber(group_id)] = true
    end
end

LdapGroup = ReqBody.LdapGroup or {}
local op_type = {'modify', 'modify', 'modify', 'modify', 'modify'}
for i = 1, 5 do
    local group_name = (LdapGroup[i] or {}).Name
    if not LdapGroup[i] or cjson.json_object_is_equal(LdapGroup[i], cjson.json_object_new_object()) then
        op_type[i] ='none'
    elseif not is_group_exist[i] and group_name and #group_name > 0 then
        op_type[i] = 'add'
    elseif is_group_exist[i] and group_name == '' then
        op_type[i] = 'delete'
    end
end

return op_type