-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local results = {}
local senser_list = ProcessingFlow[1].Destination.SensorList
local is_multihost = ProcessingFlow[2].Destination.HostType == 'Multihost'

if not senser_list or #senser_list == 0 then
    return results
end

local function format_threshold(threshold)
    if threshold == 'null' then
        return cjson.null
    end
    return tonumber(threshold)
end

for i = 1, #senser_list do
    local sensor_item = senser_list[i]
    results[#results + 1] = {
        Name = sensor_item.SensorName,
        ReadingValue = sensor_item.SensorReading ~= 'na' and sensor_item.SensorReading ~= '255.000' and
            sensor_item.SensorReading or cjson.null,
        SystemId = is_multihost and (sensor_item.SystemId ~= 0 and sensor_item.SystemId or cjson.null) or 1,
        Status = sensor_item.SensorStatus ~= 'na' and sensor_item.SensorStatus or cjson.null,
        Unit = sensor_item.SensorUnit,
        LowerThresholdCritical = format_threshold(sensor_item.LowerThresholdCritical),
        LowerThresholdFatal = format_threshold(sensor_item.LowerThresholdFatal),
        LowerThresholdNonCritical = format_threshold(sensor_item.LowerThresholdNonCritical),
        UpperThresholdCritical = format_threshold(sensor_item.UpperThresholdCritical),
        UpperThresholdFatal = format_threshold(sensor_item.UpperThresholdFatal),
        UpperThresholdNonCritical = format_threshold(sensor_item.UpperThresholdNonCritical)
    }
end

return results
