-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local port_properties = cjson.json_object_new_array()

if not Input then
    return port_properties
end

for _, v in pairs(Input) do
    if v.NetworkAttribute.MAC == '00:00:00:00:00:00' or v.NetworkAttribute.MAC == 'N/A'  then
        v.NetworkAttribute.MAC = nil
    end

    if v.NetworkAttribute.PermanentPhysicalAddress == '00:00:00:00:00:00' or
        v.NetworkAttribute.PermanentPhysicalAddress == 'N/A' then
        v.NetworkAttribute.PermanentPhysicalAddress = nil
    end

    if v.NetworkAttribute.FirmwareVersion == '' then
        v.NetworkAttribute.FirmwareVersion = null
    end

    port_properties[#port_properties + 1] = v
end

return port_properties