local min_fan_slot = 0xff
local max_fan_slot = 0

local max_fan_level = 100
for  _, cooling_fan in pairs(Input) do
    min_fan_slot = cooling_fan.FanId < min_fan_slot and cooling_fan.FanId or min_fan_slot
    max_fan_slot = cooling_fan.FanId > max_fan_slot and cooling_fan.FanId or max_fan_slot
end

local fan_level = ReqBody.ExpectedSpeedRatio
local fan_id = ReqBody.FanId and ReqBody.FanId or 0xff -- 不输入则默认全部风扇

-- 入参检查
if not fan_level or fan_level < 0 then
    return {1, min_fan_slot, max_fan_slot}
end

if fan_id and fan_id < 0 then
    return {1, min_fan_slot, max_fan_slot}
end

return {true, fan_id, fan_level}
