-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if ProcessingFlow[2].Destination.Pfcup == 0 and #ProcessingFlow[2].Destination.Up2cos == 0 and
    #ProcessingFlow[2].Destination.Pgid == 0 and #ProcessingFlow[2].Destination.PGPCT == 0 and
    #ProcessingFlow[2].Destination.PgStrict == 0 then
    return {}
else
    local dcb_info = cjson.json_object_new_object()

    dcb_info.Pfcup = ProcessingFlow[2].Destination.Pfcup
    dcb_info.Up2cos = cjson.json_object_new_array()
    dcb_info.Pgid = cjson.json_object_new_array()
    dcb_info.PGPCT = cjson.json_object_new_array()
    dcb_info.PgStrict = cjson.json_object_new_array()

    for i, value in pairs(ProcessingFlow[2].Destination.Up2cos) do
        dcb_info.Up2cos[i] = value
    end

    for i, value in pairs(ProcessingFlow[2].Destination.Pgid) do
        dcb_info.Pgid[i] = value
    end

    for i, value in pairs(ProcessingFlow[2].Destination.PGPCT) do
        dcb_info.PGPCT[i] = value
    end

    for i, value in pairs(ProcessingFlow[2].Destination.PgStrict) do
        dcb_info.PgStrict[i] = value
    end

    return dcb_info
end