-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local CONTROLLER_TYPE_ID_E = {
    LSI_3108_WITH_MR = 0,
    LSI_3108_WITH_IR = 1,
    LSI_3108_WITH_IT = 2,
    LSI_3008_WITH_MR = 3,
    LSI_3008_WITH_IR = 4,
    LSI_3008_WITH_IT = 5,
    LSI_3508_WITH_MR = 6,
    LSI_3516_WITH_MR = 7,
    LSI_3408_WITH_IMR = 8,
    LSI_3416_WITH_IMR = 9,
    LSI_3408_WITH_IT = 10,
    LSI_3416_WITH_IT = 11,
    LSI_3004_WITH_IMR = 12,
    LSI_3008_WITH_IT_PCIE = 13,
    LSI_3908_WITH_MR = 14,
    LSI_3916_WITH_MR = 15,
    LSI_3808_WITH_MR = 16,
    PMC_3152_8I_SMART_RAID = 64,
    PMC_2100_8I_SMART_HBA = 65,
    HI1880_SP186_M_16i = 96,
    HI1880_SP186_M_32i = 97,
    HI1880_SP186_M_40i = 98,
    HI1880_SP686C_M_16i_2G = 99,
    HI1880_SP686C_M_16i_4G = 100,
    HI1880_SP686C_MH_32i_4G = 101,
    HI1880_SP686C_M_40i_2G = 102,
    HI1880_SP686C_M_40i_4G = 103,
    HI1880_SPR120 = 104,
    HI1880_SPR130 = 105,
    HI1880_SPR140 = 106,
    HI1880_SPR180 = 107,
    HI1880_SPR185 = 108,
    HI1880_SPR190 = 109,
    HI1880_SPR1A0 = 110,
    HI1880_SPR1A5 = 111,
    HI1880_SPR110 = 112,
    HI1880_SP186_M_8i = 113
}

local CONTROLLER_TYPE_MAP = {
    [CONTROLLER_TYPE_ID_E.LSI_3108_WITH_MR] = 'LSI SAS3108MR',
    [CONTROLLER_TYPE_ID_E.LSI_3108_WITH_IR] = 'LSI SAS3108IR',
    [CONTROLLER_TYPE_ID_E.LSI_3108_WITH_IT] = 'LSI SAS3108IT',
    [CONTROLLER_TYPE_ID_E.LSI_3008_WITH_MR] = 'LSI SAS3008MR',
    [CONTROLLER_TYPE_ID_E.LSI_3008_WITH_IR] = 'LSI SAS3008IR',
    [CONTROLLER_TYPE_ID_E.LSI_3008_WITH_IT] = 'LSI SAS3008IT',
    [CONTROLLER_TYPE_ID_E.LSI_3508_WITH_MR] = 'Avago SAS3508MR',
    [CONTROLLER_TYPE_ID_E.LSI_3516_WITH_MR] = 'Avago SAS3516MR',
    [CONTROLLER_TYPE_ID_E.LSI_3408_WITH_IMR] = 'Avago SAS3408iMR',
    [CONTROLLER_TYPE_ID_E.LSI_3416_WITH_IMR] = 'Avago SAS3416iMR',
    [CONTROLLER_TYPE_ID_E.LSI_3408_WITH_IT] = 'Avago SAS3408IT',
    [CONTROLLER_TYPE_ID_E.LSI_3416_WITH_IT] = 'Avago SAS3416IT',
    [CONTROLLER_TYPE_ID_E.LSI_3004_WITH_IMR] = 'Avago SAS3004iMR',
    [CONTROLLER_TYPE_ID_E.LSI_3008_WITH_IT_PCIE] = 'LSI SAS3008IT(PCIe)',
    [CONTROLLER_TYPE_ID_E.LSI_3908_WITH_MR] = 'BROADCOM MegaRAID SAS 9560-8i',
    [CONTROLLER_TYPE_ID_E.LSI_3916_WITH_MR] = 'BROADCOM MegaRAID SAS 9560-16i',
    [CONTROLLER_TYPE_ID_E.LSI_3808_WITH_MR] = 'BROADCOM MegaRAID SAS 9540-8i',
    [CONTROLLER_TYPE_ID_E.PMC_3152_8I_SMART_RAID] = 'MSCC SmartRAID 3152-8i',
    [CONTROLLER_TYPE_ID_E.PMC_2100_8I_SMART_HBA] = 'MSCC SmartHBA 2100-8i',
    [CONTROLLER_TYPE_ID_E.HI1880_SP186_M_16i] = 'SP186-M-16i',
    [CONTROLLER_TYPE_ID_E.HI1880_SP186_M_32i] = 'SP186-M-32i',
    [CONTROLLER_TYPE_ID_E.HI1880_SP186_M_40i] = 'SP186-M-40i',
    [CONTROLLER_TYPE_ID_E.HI1880_SP186_M_8i] = 'SP186-M-8i',
    [CONTROLLER_TYPE_ID_E.HI1880_SP686C_M_16i_2G] = 'SP686C-M-16i 2G',
    [CONTROLLER_TYPE_ID_E.HI1880_SP686C_M_16i_4G] = 'SP686C-M-16i 4G',
    [CONTROLLER_TYPE_ID_E.HI1880_SP686C_MH_32i_4G] = 'SP686C-MH-32i 4G',
    [CONTROLLER_TYPE_ID_E.HI1880_SP686C_M_40i_2G] = 'SP686C-M-40i 2G',
    [CONTROLLER_TYPE_ID_E.HI1880_SP686C_M_40i_4G] = 'SP686C-M-40i 4G',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR110] = 'SPR110',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR120] = 'SPR120',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR130] = 'SPR130',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR140] = 'SPR140',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR180] = 'SPR180',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR185] = 'SPR185',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR190] = 'SPR190',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR1A0] = 'SPR1A0',
    [CONTROLLER_TYPE_ID_E.HI1880_SPR1A5] = 'SPR1A5'
}

return CONTROLLER_TYPE_MAP[Input] and CONTROLLER_TYPE_MAP[Input] or ''
