-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local rspbody = cjson.json_object_new_object()
rspbody.CardName = ProcessingFlow[3].Destination.Name
rspbody.CardModel = Input[3]
rspbody.CardManufacturer = ProcessingFlow[3].Destination.CardManufacturer
rspbody.ChipManufacturer = ProcessingFlow[3].Destination.ChipManufacturer
rspbody.PortProperties = cjson.json_object_new_array()
rspbody.PortProperties = Input[5]
local chip_model = ProcessingFlow[3].Destination.ChipModel
if ProcessingFlow[3].Destination.ChipModel ~= 'NPU' then
    rspbody.PCBVersion = Input[1]
    rspbody.BoardID = Input[2]
    rspbody.HotPlugAttention = ProcessingFlow[3].Destination.HotPlugAttention
    rspbody.HotPlugSupported = ProcessingFlow[3].Destination.HotPlugSupported
    rspbody.DisplayName = ProcessingFlow[3].Destination.DeviceLocator
    rspbody.OrderlyHotplugCtrlStatus = Input[4]
    rspbody.AdapterId = ProcessingFlow[3].Destination.AdapterId
    rspbody.ChipModel = string.match(chip_model, "Hi182%d") or chip_model
    rspbody.PcieSlotId = Input[6]
    rspbody.AssociatedResource = ProcessingFlow[3].Destination.AssociatedResource
    rspbody.ComponentUniqueID = ProcessingFlow[3].Destination.ComponentUniqueID
    rspbody.BusInfo = Input[7]
    rspbody.Type = ProcessingFlow[3].Destination.Type
    rspbody.ParentCardSlotId = ProcessingFlow[3].Destination.ParentCardSlotId
    rspbody.BandwidthThresholdPercent = ProcessingFlow[3].Destination.BandwidthThresholdPercent
    rspbody.NetDevFuncCapabilities = ProcessingFlow[3].Destination.NetDevFuncCapabilities
end
if ProcessingFlow[4].Destination.HostType == 'Multihost' then
    rspbody.AssociatedResource = cjson.null
    rspbody.BusInfo = cjson.null
end
return rspbody