-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

function m.get_version_str(version)
    local t = {}
    for i = 0, 3 do
        t[i + 1] = (version & ((0xff) << (i*8))) >> (i*8)
    end
    return string.format("%d.%d.%d.%d", t[1], t[2], t[3], t[4])
end

local TCM_ALL_MEMBER_MAP = {
    [0x1b4e] = "国民技术",
    [0x0] = "未知厂商"
}

function m.get_tcm_manufacturer(manufacturer_id)
    if TCM_ALL_MEMBER_MAP[manufacturer_id] == nil then
        return TCM_ALL_MEMBER_MAP[0];
    end

    return TCM_ALL_MEMBER_MAP[manufacturer_id];
end

return m
