-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

---获取BMC系统时间
---@param date_time string
function m.get_sys_time(date_time, time_zone)
    -- date_time的格式："2023-04-07T19:32:55+08:00"，转换为"2023-04-07 19:32:55 (UTC+08:00)"
    date_time = string.gsub(date_time, "T", " ")

    local offset = string.sub(date_time, -6)

    local utc_offset
    if string.match(time_zone, 'GMT') then
        utc_offset = string.format(" (GMT%s)", offset)
    else
        utc_offset = string.format(" (UTC%s)", offset)
    end

    date_time = string.gsub(date_time, offset, utc_offset)

    return date_time
end

return m
