-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local syslog = {}

function syslog.get_server_list(server_list)
    if not server_list or not cjson.json_object_is_array(server_list) or #server_list == 0 then
        return
    end

    local t = cjson.json_object_copy(server_list)
    for _, server in pairs(t) do
        server.MemberId = server.MemberId + 1
    end

    return t
end

function syslog.get_server_log_list(server_list)
    if not server_list or not cjson.json_object_is_array(server_list) or #server_list == 0 then
        return
    end

    local t = cjson.json_object_new_array()
    for _, server in pairs(server_list) do
        if server.LogItem == nil then
            goto continue
        end
        for _, server_log in pairs(server.LogItem) do
            local s = cjson.json_object_new_object()
            s.MemberId = server.MemberId + 1
            s.LogType = server_log.LogType
            if server_log.Port ~= nil then
                s.Port = server_log.Port
            end
            if server_log.Enabled ~= nil then
                s.Enabled = server_log.Enabled
            end
            if server_log.TransmissionProtocol ~= nil then
                s.TransmissionProtocol = server_log.TransmissionProtocol
            end

            t[#t + 1] = s
        end

        ::continue::
    end

    if #t == 0 then
        return
    end

    return t
end

return syslog
