-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local json = require 'cjson'
local m = {}

function m.get_port_config(enabled, port, spare_port)
    if enabled == nil and port == nil and spare_port == nil then
        return json.null
    end

    local protocol = json.json_object_new_object()
    if enabled ~= nil then
        protocol.Enabled = enabled
    end

    if port ~= nil then
        protocol.Port = port
    end

    if spare_port ~= nil then
        protocol.SparePort = spare_port
    end

    return protocol
end

return m
