-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils = require 'mc.utils'

local m = {}

local language_set_support = {
    ['en'] = true,
    ['zh'] = true,
    ['ja'] = true,
    ['fr'] = true,
    ['ru'] = true
}

-- 添加语言
function m.add_language(mdb_lang, add_lang_str)
    local add_langs = utils.split(add_lang_str, ',') or {}
    if next(add_langs) == nil then
        error(custom_messages.LanguageNotSupport(add_lang_str))
    end

    local res = mdb_lang
    for _, add_lang in ipairs(add_langs) do
        if not language_set_support[add_lang] then
            error(custom_messages.LanguageNotSupport(add_lang))
        end
        if utils.array_contains(mdb_lang, add_lang) then
            error(base_messages.ResourceAlreadyExists())
        end
        res[#res + 1] = add_lang
    end

    return res
end

-- 删除语言
function m.remove_language(mdb_lang, rm_lang_str)
    local rm_langs = utils.split(rm_lang_str, ',') or {}
    if next(rm_langs) == nil then
        error(custom_messages.LanguageNotSupport(rm_lang_str))
    end

    -- 检查传入的是否合法
    for _, rm_lang in ipairs(rm_langs) do
        if not language_set_support[rm_lang] then
            error(custom_messages.LanguageNotSupport(rm_lang))
        end
        if not utils.array_contains(mdb_lang, rm_lang) then
            error(custom_messages.LanguageNotInstalled(rm_lang))
        end
    end

    local res = {}
    for _, lang in ipairs(mdb_lang) do
        if not utils.array_contains(rm_langs, lang) then
            res[#res + 1] = lang
        end
    end
    return res
end

return m