-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

function m.check_skip_and_top(skip, top)
    if not skip then
        error(base_messages.PropertyMissing("Skip"))
    end
    if not top then
        error(base_messages.PropertyMissing("Top"))
    end

    if not string.match(skip, '^%d+$') then
        error(base_messages.PropertyValueTypeError(skip, "Skip"))
    end

    if tonumber(skip) < 0 or tonumber(skip) > 65535 then
        error(base_messages.QueryParameterOutOfRange(skip, 'Skip', '0-65535'))
    end

    if not string.match(top, '^%d+$') then
        error(base_messages.PropertyValueTypeError(top, "Top"))
    end

    if tonumber(top) < 0 or tonumber(top) > 65535 then
        error(base_messages.QueryParameterOutOfRange(top, 'Top', '0-65535'))
    end

    return true
end

return m
