-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

-- 处理器资源树接口
local FAN_MDB_INTF <const> = "bmc.kepler.Systems.Fan"

---获取在位风扇的个数
---@param fan_paths any
---@return integer
function m.get_presence_count(fan_paths)
    local count = 0
    for _, path in ipairs(fan_paths) do
        local obj = mdb.get_object(bus, path, FAN_MDB_INTF)
        if obj.RearPresence == 1 then -- 风扇的后转子在位状态
            count = count + 1
        end
    end

    return count
end

return m
