-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local file_utils = require 'utils.file'
local core_utils = require 'utils.core'

local m = {}

function m.is_import_permitted(content, result, ctx)
    if content:sub(1,1) ~= '/' then
        return true
    end

    local uri_pattern = "^((https|sftp|nfs|cifs|scp)://.{1,1000}|/tmp/.{1,246})\\.json$"
    if not core_utils.g_regex_match(uri_pattern, content) then
        error(base_messages.PropertyValueFormatError("******", "Content"))
    end

    if not core_utils.is_file(content) then
        error(custom_messages.InvalidPath("******", "Content"))
    end

    if file_utils.check_real_path_s(content, "/tmp") ~= 0 then
        error(custom_messages.InvalidPath("******", "Content"))
    end

    for _, rold_id in pairs(ctx.RoleId) do
        if rold_id == "Administrator" then
            return true
        end
    end

    if result then
        return true
    end
    error(custom_messages.NoPrivilegeToOperateSpecifiedFile())
end

return m
