-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

local function band(data, mask)
    if data == nil or mask == nil then
        return
    end

    if type(data) ~= "number" or type(mask) ~= "number" then
        return
    end

    return data & mask
end

local severity_mask = {
    None = 0x0,
    Normal = 0x0f,
    Minor = 0xe,
    Major = 0xc,
    Critical = 0x8
}

function m.get_severity_name(severity)
    if not severity then
        return
    end

    if band(severity, 0x01) == 1 then
        return "Normal"
    elseif band(severity, 0x02) == 2 then
        return "Minor"
    elseif band(severity, 0x04) == 4 then
        return "Major"
    elseif band(severity, 0x08) == 8 then
        return "Critical"
    elseif severity == 0 then
        return "None"
    end
end

function m.get_severity_mask(severity)
    if not severity then
        return
    end

    local mask = severity_mask[severity]
    if mask == nil then
        return 0xFF
    end

    return mask
end

function m.get_server_list(server_list)
    if not server_list or not cjson.json_object_is_array(server_list) or #server_list == 0 then
        return
    end

    for _, server in pairs(server_list) do
        server.ID = server.ID + 1
    end

    return server_list
end

return m
