-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local INLET_TEMP_NAME<const> = 'Inlet Temp'         -- 进风口温度
local CPU_TEMP_NAME<const> = 'CPU.* Core Rem'      -- CPU温度

local sensors = ProcessingFlow[1].Destination.SensorList or {}
local temperature_list = {}
local index = 1

table.sort(sensors, function(a, b)
    return a.SensorName < b.SensorName
end)

for _, v in pairs(sensors) do
    local temp_obj = ''
    if v.SensorIdentifier == INLET_TEMP_NAME then
        temp_obj = 'Inlet'
    end
    if string.match(v.SensorIdentifier, CPU_TEMP_NAME) then
        temp_obj = string.sub(v.SensorIdentifier, 1, 4)
    end

    if temp_obj ~= '' then
        temperature_list[#temperature_list + 1] = {
            temperatureIndex = index,
            temperatureObject = temp_obj,
            -- snmp接口显示的温度单位为1/10摄氏度，因此此处*10，65535表示NA或null
            temperatureReading = v.SensorReading == 'na' and 65535 or tonumber(v.SensorReading) * 10,
            temperatureUpperNonRecoverable = v.UpperThresholdFatal ==
                'null' and 65535 or tonumber(v.UpperThresholdFatal) * 10,
            temperatureUpperCritical = v.UpperThresholdCritical ==
                'null' and 65535 or tonumber(v.UpperThresholdCritical) * 10,
            temperatureUpperMinor = v.UpperThresholdNonCritical ==
                'null' and 65535 or tonumber(v.UpperThresholdNonCritical) * 10
        }
        index = index + 1
    end
end

return temperature_list