-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local disk_array_path_list = Input
local SPAN_CHECK_FLAG<const> = 0x8000
local target_path = {}
if not disk_array_path_list then
    return target_path
end
local last_part = nil
local number = nil
for _, disk_array_path in pairs(disk_array_path_list) do
    -- 找到最后一个斜杠的位置
    last_part = string.match(disk_array_path, "/([^/]+)$")
    number = tonumber(last_part)
    if number and number < SPAN_CHECK_FLAG then
        target_path[#target_path + 1] = disk_array_path
    end
end

return target_path