-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local pcie_card_list = {}
local pcie_cards = Input

for _, value in pairs(pcie_cards) do
    pcie_card_list[#pcie_card_list + 1] = {
        pCIeDeviceIndex = value.pCIeDeviceIndex,
        pCIeDevicePresence = value.pCIeDevicePresence,
        pCIeDeviceStatus = value.pCIeDeviceStatus + 1,
        pCIeAvailability = value.pCIeAvailability,
        pCIeDeviceLocation = value.pCIeDeviceLocation,
        pCIeDeviceFunction = "PCIe device",
        pCIeDeviceDevicename = value.pCIeDeviceDevicename,
        pCIeDeviceVID = value.pCIeDeviceVID,
        pCIeDeviceDID = value.pCIeDeviceDID,
        pCIeDeviceManufacturer = value.pCIeDeviceManufacturer,
        pCIeDeviceDescription = value.pCIeDeviceDescription
    }
end
return pcie_card_list