-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if Input == nil then return nil end
local interface = string.match(Input, '^ui=(%d+)')
local interfaceNumber = tonumber(interface)
local interface_map = { 'Web', 'SNMP', 'IPMI', 'SSH', 'SFTP', 'none', 'Local', 'Redfish' }
local res = {}
local bit_number = 1
for _, v in pairs(interface_map) do
    if (interfaceNumber & bit_number) ~= 0 then if v ~= 'none' then res[#res + 1] = v end end
    bit_number = bit_number * 2
end
return res
