-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local LED_COLOR_STR<const> = {
    "reserved",
    "BLUE",
    "RED",
    "GREEN",
    "AMBER",
    "ORANGE",
    "WHITE",
}

local color_capabilities = ProcessingFlow[1].Destination.ColorCapabilities
local color_capabilities_str = ''

for i = 1, #LED_COLOR_STR do
    local color_support = color_capabilities & (1 << (i - 1))
    if color_support ~= 0 then
        if color_capabilities_str ~= '' then
            color_capabilities_str = color_capabilities_str .. ','
        end
        color_capabilities_str = color_capabilities_str .. LED_COLOR_STR[i]
    end
end

return color_capabilities_str