-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local fan_list = {}
local fans = Input
local index = 1
local FAN_PRESENCE_ABSENCE = 1
local SNMP_HEALTHE_STATE_ABSENCE = 5
local FAN_STATUS_UNKNOWN = 5
local FAN_SPEED_RATIO_MAX = 100
local power_state = ProcessingFlow[3].Destination.PowerState
local standby_fan_enabled = ProcessingFlow[4].Destination.WorkInStandby

-- 获取风扇在位信息
local function get_fan_presence(presence)
    if presence ~= 1 then
        return FAN_PRESENCE_ABSENCE
    end
    return presence + 1
end

-- 获取风扇状态
local function get_fan_status(presence, status)
    if presence ~= 1 then
        return SNMP_HEALTHE_STATE_ABSENCE
    end
    if power_state == 'OFF' and standby_fan_enabled == 0 then
        return FAN_STATUS_UNKNOWN
    end
    return status + 1
end

-- 通过FanId进行排序
table.sort(fans, function(a, b) return a.FanId < b.FanId end)
for _, value in pairs(fans) do
    local speed_ratio
    if value.IsTwins then -- 对称风扇
        speed_ratio = value.FrontSpeed * value.Coefficient * 100 // value.FrontMaxSpeed
        speed_ratio = speed_ratio > FAN_SPEED_RATIO_MAX and FAN_SPEED_RATIO_MAX or speed_ratio
        fan_list[#fan_list + 1] = {
            fanIndex = index,
            fanSpeed = value.FrontSpeed,
            fanPresence = get_fan_presence(value.FrontPresence),
            fanStatus = get_fan_status(value.FrontPresence, value.FrontStatus),
            fanLocation = value.Position,
            fanFunction = 'cooling',
            fanDevicename = 'Fan' .. value.FanId .. ' Front',
            fanSpeedRatio = speed_ratio
        }
        index = index + 1
        speed_ratio = value.RearSpeed * value.Coefficient * 100 // value.RearMaxSpeed
        speed_ratio = speed_ratio > FAN_SPEED_RATIO_MAX and FAN_SPEED_RATIO_MAX or speed_ratio
        fan_list[#fan_list + 1] = {
            fanIndex = index,
            fanSpeed = value.RearSpeed,
            fanPresence = get_fan_presence(value.RearPresence),
            fanStatus = get_fan_status(value.RearPresence, value.RearStatus),
            fanLocation = value.Position,
            fanFunction = 'cooling',
            fanDevicename = 'Fan' .. value.FanId .. ' Rear',
            fanSpeedRatio = speed_ratio
        }
    else
        speed_ratio = value.RearSpeed * value.Coefficient * 100 // value.RearMaxSpeed
        speed_ratio = speed_ratio > FAN_SPEED_RATIO_MAX and FAN_SPEED_RATIO_MAX or speed_ratio
        fan_list[#fan_list + 1] = {
            fanIndex = index,
            fanSpeed = value.RearSpeed,
            fanPresence = get_fan_presence(value.RearPresence),
            fanStatus = get_fan_status(value.RearPresence, value.RearStatus),
            fanLocation = value.Position,
            fanFunction = 'cooling',
            fanDevicename = 'Fan' .. value.FanId,
            fanSpeedRatio = speed_ratio
        }
    end
    index = index + 1
end

return fan_list