-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

-- 处理数字格式的时间
function m.format_number_time_zone(input, configurable)
    if not configurable then
        return 'not support'
    end

    local symbol = input > 0 and '+' or '-'
    local minutes = math.abs(input)
    return string.format('%s%02d:%02d', symbol, math.floor(minutes / 60), minutes % 60)
end

-- 处理字符串格式的时间
function m.format_string_time_zone(input, configurable)
    if not configurable then
        return 'not support'
    end

    -- 校验是否符合数字格式(以+/-开头或者纯数字)
    local symbol = string.sub(input, 1, 1)
    local minutes
    if symbol == '-' or symbol == '+' then
        minutes = tonumber(string.sub(input, 2))
    else
        symbol = ''
        minutes = tonumber(input)
    end

    -- 不合法或者其他格式都直接返回
    if not minutes then
        return input
    end
    return string.format('%s%02d:%02d', symbol, math.floor(minutes / 60), minutes % 60)
end


return m
