-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local messages = require 'messages'

local MSG_SUFFIX <const> = 'Message'

local m = {}

function m.get_task_message(MessageId, MessageArgs)
    if not MessageId or not MessageArgs then
        return ''
    end

    local message_name = MessageId .. MSG_SUFFIX

    local message
    for _, message_collection in pairs(messages) do
        if message_collection[message_name] then
            message = message_collection[message_name]
            break
        end
    end

    if not message then
        -- 错误引擎中没有定义的错误类型，则直接返回MessageId
        return MessageId
    end

    local ok, task_message = pcall(string.format, message.Format, table.unpack(MessageArgs))
    if not ok then
        return MessageId
    end

    return task_message
end

return m
