-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local index = string.match(PropertyName, 'Oem/{{OemIdentifier}}/LoginRule/(%d)/')
if index == nil then
    return
end

if ReqBody.Oem["{{OemIdentifier}}"].LoginRule[index + 1].EndTime ~= nil and
    ReqBody.Oem["{{OemIdentifier}}"].LoginRule[index + 1].StartTime == nil then
    local err = base_messages.PropertyMissing('Oem/{{OemIdentifier}}/LoginRule/' .. index .. '/StartTime')
    err.RelatedProperties = {'#/Oem/{{OemIdentifier}}/LoginRule/' .. index .. '/EndTime'}
    error(err)
end

return true
