-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local states = ProcessingFlow[1].Destination
local supported = ProcessingFlow[2].Destination.TlsCapabilities
local supported_map = {}
for _, v in pairs(supported) do
    supported_map[v.TlsName] = v.IsSupported
end
local disabled = {}
local result = cjson.json_object_new_array()
local map = {
    ['TLS_1_0_Enabled'] = 'TLS1.0',
    ['TLS_1_1_Enabled'] = 'TLS1.1',
    ['TLS_1_2_Enabled'] = 'TLS1.2',
    ['TLS_1_3_Enabled'] = 'TLS1.3'
}

local tls_map = {
    ['TLS1.0'] = '1.0',
    ['TLS1.1'] = '1.1',
    ['TLS1.2'] = '1.2',
    ['TLS1.3'] = '1.3'
}

for k, v in pairs(map) do
    if not states[k] then
        table.insert(disabled, v)
    end
end
table.sort(disabled)

for _, v in pairs(disabled) do
    if supported_map[v] then
        result[#result + 1] = tls_map[v]
    end
end
if #result == 0 then
    result[#result + 1] = "NONE"
end

return result
