-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ssl_chipersuites_table = {
    ['ECDHE-RSA-AES256-GCM-SHA384Enabled'] = 0,
    ['ECDHE-ECDSA-AES256-GCM-SHA384Enabled'] = 1,
    ['DHE-RSA-AES256-GCM-SHA384Enabled'] = 3,
    ['ECDHE-RSA-AES128-GCM-SHA256Enabled'] = 4,
    ['ECDHE-ECDSA-AES128-GCM-SHA256Enabled'] = 5,
    ['DHE-RSA-AES128-GCM-SHA256Enabled'] = 7,
    ['ECDHE-RSA-CHACHA20-POLY1305Enabled'] = 11,
    ['DHE-RSA-AES128-CCMEnabled'] = 13,
    ['DHE-RSA-AES256-CCMEnabled'] = 14,
    ['DHE-RSA-CHACHA20-POLY1305Enabled'] = 15,
    ['ECDHE-ECDSA-AES128-CCMEnabled'] = 18,
    ['ECDHE-ECDSA-AES256-CCMEnabled'] = 19,
    ['ECDHE-ECDSA-CHACHA20-POLY1305Enabled'] = 20,
    ['TLS_CHACHA20_POLY1305_SHA256Enabled'] = 21,
    ['TLS_AES_256_GCM_SHA384Enabled'] = 22,
    ['TLS_AES_128_GCM_SHA256Enabled'] = 23
}

local res = cjson.json_object_new_object()
res.ids = cjson.json_object_new_array()
res.states = cjson.json_object_new_array()

local id
for k, v in pairs(ReqBody.SSLCipherSuites) do
    id = ssl_chipersuites_table[k]
    if id then
        res.ids[#res.ids + 1] = id
        res.states[#res.states + 1] = v
    end
end

return res
