-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local id = string.upper(Uri.id)

if string.match(id, 'CHASSISPSU%d') then
    return 'chassis' .. string.match(id, 'PSU%d')
end

for _, path in pairs(ProcessingFlow[3].Destination.Members) do
    local obj_id = string.match(path, '/bmc/kepler/UpdateService/FirmwareInventory/(.*)')
    if id == string.upper(obj_id) then
        return obj_id
    end
end

--为SR、CPLD、MUC、VRD
for _, board in ipairs(Input) do
    --出现(和)会导致match函数匹配不到，加%转为普通字符
    local node_id = board.NodeId:gsub("(%W)", "%%%1")
    node_id = string.upper(node_id)

    if node_id ~= "" and string.match(id, node_id) then
        return  id:gsub(node_id, board.NodeId)
    end
end

return Uri.id