-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skip = tonumber(Query.Skip)
local top = tonumber(Query.Top)
local count = tonumber(ProcessingFlow[1].Destination.CurEventCount)
if skip >= count then
    error(base_messages.QueryParameterOutOfRange(skip, '$skip', '0-' .. count - 1))
elseif skip + top > count or top <= 0 then
    error(base_messages.QueryParameterOutOfRange(top, '$top', '1-' .. (count - skip)))
end
