-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local req_obj = Input
local req_obj_t = cjson.json_object_to_table(req_obj)
local rsp_t = {}
local is_onboot_t = {
    ["true"] = "yes",
    ["false"] = "no"
}

if req_obj_t.LinkStatus ~= nil then
    rsp_t.LinkStatus = req_obj_t.LinkStatus
end
if req_obj_t.IPv4Addresses then
    rsp_t.IPv4Addresses = cjson.encode(req_obj_t.IPv4Addresses)
end
if req_obj_t.IsOnBoot ~= nil then
    rsp_t.OnBoot = is_onboot_t[string.lower(tostring(req_obj_t.IsOnBoot))]
end

return rsp_t
