-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local count = Input
local skip = tonumber(Query.Skip) or 0
local top = tonumber(Query.Top)  or ((count - skip) > 32 and 32 or (count - skip))
if skip ~= math.floor(skip) then
    error(base_messages.QueryParameterValueTypeError(skip, '$skip'))
elseif top ~= math.floor(top) then
    error(base_messages.QueryParameterValueTypeError(top, '$top'))
end
if skip >= count and count > 0 then
    error(base_messages.QueryParameterOutOfRange(skip, '$skip', '0-' .. count - 1))
elseif (skip + top > count or top <= 0) and count > 0 then
    error(base_messages.QueryParameterOutOfRange(top, '$top', '1-' .. (count - skip)))
end
