-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local current_members = Input
local skip = Query.Skip or 0
local top = Query.Top or ((#current_members - skip) > 32 and 32 or (#current_members - skip))

local list = {}
if not current_members or #current_members == 0 then
    return list
end
if #current_members <= tonumber(skip) then
    return list
end
for i = 1, top, 1 do
    if (#current_members - skip - i + 1) > 0 then
        list[i] = current_members[i + skip]
    end
end
return list