-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if ReqBody.Mode == 'Upgrade' then
    if ReqBody.ImageURI == nil then
        local err = base_messages.PropertyMissing('Image')
        err.RelatedProperties = {'#/ImageURI'}
        error(err)
    end

    if ReqBody.SignatureURI == nil then
        local err = base_messages.PropertyMissing('Signature')
        err.RelatedProperties = {'#/SignatureURI'}
        error(err)
    end

    if ReqBody.CrlURI == nil then
        local err = base_messages.PropertyMissing('Crl')
        err.RelatedProperties = {'#/CrlURI'}
        error(err)
    end
end

if ReqBody.Mode == 'Delete' then
    if ReqBody.ImageURI ~= nil then
        local err = custom_messages.IBMADeleteParameterError('Image')
        err.RelatedProperties = {'#/ImageURI'}
        error(err)
    end

    if ReqBody.SignatureURI ~= nil then
        local err = custom_messages.IBMADeleteParameterError('Signature')
        err.RelatedProperties = {'#/SignatureURI'}
        error(err)
    end

    if ReqBody.CrlURI ~= nil then
        local err = custom_messages.IBMADeleteParameterError('Crl')
        err.RelatedProperties = {'#/CrlURI'}
        error(err)
    end
end
