-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local suite_paths = ProcessingFlow[8].Destination.RMCPCipherSuitesList
local reqs = ReqBody.RMCPCipherSuites

local res = {}

local id, suite
for _, v in pairs(suite_paths) do
    id = string.match(v, 'RMCPCipherSuites_(%d+)')
    suite = 'CipherSuite' .. id
    if reqs[suite] and reqs[suite].Enabled ~= nil then
        if reqs[suite].Enabled then
            table.insert(res, 1, {Path = v, Enabled = reqs[suite].Enabled, Req = suite})
        else
            table.insert(res, {Path = v, Enabled = reqs[suite].Enabled, Req = suite})
        end
    end
end

return res
