-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ipv6_addresses = {}

local address = {
    Address = ProcessingFlow[7].Destination.Address ~= '' and ProcessingFlow[7].Destination.Address or cjson.null,
    PrefixLength = ProcessingFlow[7].Destination.PrefixLength ~= 0 and ProcessingFlow[7].Destination.PrefixLength or
        cjson.null,
    AddressOrigin = ProcessingFlow[7].Destination.AddressOrigin
}
table.insert(ipv6_addresses, address)

local link_local_address = ProcessingFlow[5].Destination.LinkLocalAddress
if link_local_address ~= nil and link_local_address ~= '' then
    local p1, p2 = string.find(link_local_address, '/')
    local link_local = string.sub(link_local_address, 1, p1 - 1)
    local link_local_prefix = tonumber(string.sub(link_local_address, p2 + 1))
    local local_address = {
        Address = link_local ~= '' and link_local or cjson.null,
        PrefixLength = link_local_prefix ~= 0 and link_local_prefix or cjson.null,
        AddressOrigin = 'LinkLocal'
    }
    table.insert(ipv6_addresses, local_address)
end

local SLAAC_address_list = ProcessingFlow[5].Destination.SLAACAddressList
if SLAAC_address_list ~= nil and next(SLAAC_address_list) ~= nil then
    for i in pairs(SLAAC_address_list) do
        local p1, p2 = string.find(SLAAC_address_list[i], '/')
        local ipaddr = string.sub(SLAAC_address_list[i], 1, p1 - 1)
        local prefix = tonumber(string.sub(SLAAC_address_list[i], p2 + 1))
        local slaac_address = {
            Address = ipaddr ~= '' and ipaddr or cjson.null,
            PrefixLength = prefix ~= 0 and prefix or cjson.null,
            AddressOrigin = 'SLAAC'
        }
        table.insert(ipv6_addresses, slaac_address)
    end
end

return ipv6_addresses