-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if ReqBody.DHCPv6 ~= nil and ReqBody.DHCPv6.OperatingMode == 'Stateful' and
    (ReqBody.IPv6Addresses ~= nil or ReqBody.IPv6StaticAddresses ~= nil or
    ReqBody.IPv6StaticDefaultGateways ~= nil) then
    local err = custom_messages.IPv6InfoConflictwithDHCPv6()
    err.RelatedProperties = {'#/DHCPv6'}

    if ReqBody.IPv6Addresses ~= nil then
        table.insert(err.RelatedProperties, '#/IPv6Addresses')
    end

    if ReqBody.IPv6StaticAddresses ~= nil then
        table.insert(err.RelatedProperties, '#/IPv6StaticAddresses')
    end

    if ReqBody.IPv6StaticDefaultGateways ~= nil then
        table.insert(err.RelatedProperties, '#/IPv6StaticDefaultGateways')
    end
    error(err)
end

-- 如果当前模式为dhcpv6，但没传ip地址，则前缀不能设置
if ProcessingFlow[5].Destination.IpMode == 'DHCPv6' and ReqBody.IPv6StaticAddresses ~= nil and
    ReqBody.IPv6StaticAddresses[1].Address == nil then
    if ReqBody.IPv6StaticAddresses[1].PrefixLength ~= nil then
        local err = custom_messages.IPv6InfoConflictwithDHCPv6()
        err.RelatedProperties = {'#/IPv6StaticAddresses/0/PrefixLength'}
        error(err)
    end
end

return true
