-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if ReqBody.IPv6Addresses == nil then
    return false
end

if ReqBody.IPv6Addresses[1].Address == nil and ReqBody.IPv6Addresses[1].PrefixLength == nil then
    return false
end

if ReqBody.IPv6Addresses[1].AddressOrigin == 'DHCPv6' and
    (ReqBody.IPv6Addresses[1].Address ~= nil or ReqBody.IPv6Addresses[1].PrefixLength ~= nil) then
    local err = custom_messages.IPv6InfoConflictwithDHCPv6()
    err.RelatedProperties = {'#/IPv6Addresses/0'}
    error(err)
end

-- 如果当前模式为dhcpv6，但没传ip地址和静态ip模式，则前缀不能设置
if ProcessingFlow[3].Destination.IpMode == 'DHCPv6' and ReqBody.IPv6Addresses[1].AddressOrigin ~=
    'Static' and ReqBody.IPv6Addresses[1].Address == nil then
    if ReqBody.IPv6Addresses[1].PrefixLength ~= nil then
        local err = custom_messages.IPv6InfoConflictwithDHCPv6()
        err.RelatedProperties = {'#/IPv6Addresses/0/PrefixLength'}
        error(err)
    end
end

return true
