-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local res = {}
local JOB_PROPERTYS = {
    'CreatedBy',
    'StartTime',
    'HidePayload'
}
local data_encode = {
    ['table'] = function(data)
        return cjson.encode(data)
    end,
    ['userdata'] = function(data)
        if cjson.json_object_is_object(data) or cjson.json_object_is_array(data) then
            return cjson.json_object_ordered_encode(data)
        elseif data == cjson.null then
            return 'null'
        else
            return 'unknown'
        end
    end,
    ['number'] = function(data)
        return tostring(data)
    end,
    ['boolean'] = function(data)
        return data and 'true' or 'false'
    end,
    ['string'] = function(data)
        return data
    end
}

local function encode_to_string(data)
    return data_encode[type(data)] and data_encode[type(data)](data) or 'unknown'
end

for key, value in pairs(Input) do
    for _, val in ipairs(JOB_PROPERTYS) do
        if key == val then
            res[key] = encode_to_string(value)
            break
        end
    end
    if key == "Schedule" then
        for k, v in pairs(value) do
            res[k] = encode_to_string(v)
        end
    end
    if key == "Payload" and value.JsonBody then
        res['JsonBody'] = value.JsonBody
    end
end

res['JobType'] = Input.Oem["{{OemIdentifier}}"].JobType

return res
