-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local str = Input
local err
if #str == 0 then
    err = base_messages.PropertyValueFormatError(Input, 'RecurrenceInterval')
    err.RelatedProperties = {'#/Schedule/RecurrenceInterval'}
    error(err)
end
local date_str
local time_str
str = string.upper(str)
str = string.match(str, "P(.+)")
local index = string.find(str, "T")
if not index then
    date_str = str
else
    date_str = string.sub(str, 1, index - 1)
    time_str = string.sub(str, index + 1, #str)
end
local day = string.match(date_str or '', "(%d+)D") or 0
local hour = string.match(time_str or '', "(%d+)H") or 0
local minute = string.match(time_str or '', "(%d+)M") or 0
if day == 0 and hour == 0 and minute == 0 then
    err = base_messages.PropertyValueFormatError(Input, 'RecurrenceInterval')
    err.RelatedProperties = {'#/Schedule/RecurrenceInterval'}
    error(err)
end

if (day * 24 * 60 + hour * 60 + minute) < 15 then
    err = custom_messages.PropertyValueOutOfRange(Input, 'RecurrenceInterval')
    err.RelatedProperties = {'#/Schedule/RecurrenceInterval'}
    error(err)
end

return true

