-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local res = ReqBody.Oem["{{OemIdentifier}}"].ShieldResourcesForSubscriptions
if not res then
    return
end

local valid_res = cjson.json_object_new_array()
for _, v in ipairs(res) do
    if not cjson.json_object_is_equal(v, cjson.json_object_new_object()) then
        valid_res[#valid_res + 1] = v
    end
end

return cjson.json_object_ordered_encode(valid_res)
