-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local model = ProcessingFlow[8].Destination.Model
local network_adapter_id = ProcessingFlow[8].Destination.ID
local port_id = Input
local port_list = {}
port_list[1] = string.format('/redfish/v1/Chassis/1/NetworkAdapters/%s/NetworkPorts/%s',
    network_adapter_id, port_id + 1)
if model == 'NPU' then
    --当前连续的两个portid关联的是同一个NPU模组/光模块，例如port1和port2
    local other_port_id = (port_id // 2) * 4 + 1 - port_id
    port_list[2] = string.format('/redfish/v1/Chassis/1/NetworkAdapters/%s/NetworkPorts/%s',
        network_adapter_id, other_port_id + 1)
end
return port_list