-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local power_control = ReqBody.PowerControl[tonumber(Uri.chassisid)]

if power_control ~= nil and power_control.PowerLimit ~= nil then
    local limit_in_watts = power_control.PowerLimit.LimitInWatts
    if limit_in_watts ~= nil and limit_in_watts ~= cjson.null then
        local args = 'PowerControl/' .. (tonumber(Uri.chassisid) - 1) .. '/PowerLimit/LimitInWatts'
        if type(limit_in_watts) ~= "number" then
            error(base_messages.PropertyValueTypeError(limit_in_watts, args))
        end
        if math.type(limit_in_watts) ~= "integer" then
            error(base_messages.PropertyValueTypeError(string.format("%.6f", limit_in_watts), args))
        end
    end
end
