-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local SpareforLogicalDrives = {}
local HotspareType = ProcessingFlow[2].Destination.HotspareType
local RefControllerId = ProcessingFlow[2].Destination.RefControllerId
local RefVolumeList = ProcessingFlow[2].Destination.RefVolumeList

if HotspareType == 0 or HotspareType == 1 then
    return SpareforLogicalDrives
else
    for _, item in ipairs(RefVolumeList) do
        SpareforLogicalDrives[#SpareforLogicalDrives + 1] = {
            ["@odata.id"] =
            "/redfish/v1/Systems/1/Storages/RAIDStorage" .. RefControllerId ..
            "/Volumes/LogicalDrive" .. item
        }
    end
    return SpareforLogicalDrives
end
