-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local state_map = {
    [0] = 'Enabled',
    [1] = 'Enabled',
    [2] = 'StandbySpare',
    [3] = 'StandbyOffline',
    [4] = 'Enabled',
    [5] = 'Enabled',
    [6] = 'Enabled',
    [7] = 'Enabled',
    [8] = 'Enabled',
    [9] = 'Disabled',
    [10] = 'Disabled',
    [11] = 'Disabled',
    [12] = 'Disabled',
    [13] = 'Enabled',
    [14] = 'StandbyOffline',
    [15] = 'StandbyOffline',
    [16] = 'Enabled',
    [17] = 'Enabled',
    [18] = 'Enabled',
    [19] = 'Enabled',
    [20] = 'Enabled',
    [21] = 'Enabled',
    [22] = 'Disabled',
    [23] = 'Enabled',
    [24] = 'Updating',
    [25] = 'Disabled',
    [26] = 'Updating'
}

local media_type = ProcessingFlow[2].Destination.MediaType
local protocol = ProcessingFlow[2].Destination.Protocol

if media_type == 1 and protocol == 6 then
    return 'Enabled'
end

local firmware_status = ProcessingFlow[2].Destination.FirmwareStatus

return state_map[firmware_status] or null
