-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
-- Desription: 登录时间规则管理
local m = {}

function m.get_time_rule(login_rule)
    local time_rule = {}

    if login_rule ~= nil then
        for _, item in ipairs(login_rule) do
            if item.StartTime == "" and item.EndTime == "" then
                time_rule[#time_rule + 1] = ""
            elseif item.StartTime ~= nil and item.EndTime ~= nil then
                time_rule[#time_rule + 1] = item.StartTime .. "/" .. item.EndTime
            else
                time_rule[#time_rule + 1] = null
            end
        end
    end

    return time_rule
end

function m.get_start_end_time(time_rule)
    local delimiter = "/"

    local result = {}
    for match in (time_rule .. delimiter):gmatch('(.-)' .. delimiter) do

        table.insert(result, match ~= '' and match or cjson.null)
    end

    return result
end

function m.set_manager_datetime()
    local val = 'DateTime'
    local err = custom_messages.PropertyModificationNotSupported(val)
    err.RelatedProperties = {'#/' .. val}
    error(err)

end

function m.check_timezone_configurable(date, path)
    local obj = mdb.get_object(bus, path, 'bmc.kepler.Managers.Time')
    if not obj.TimeZoneConfigurable then
        return 'not support'
    end

    return date
end

return m
