-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local utils_core = require 'utils.core'

local m = {}

local STARTUP_TIME_INTERVAL = 26

function m.get_startup_state(startup_time)
    local ret, uptime = pcall(utils_core.get_bmc_uptime)
    if not ret then
        return 'Starting'
    end

    -- 启动时间规格小于时间间隔，认为启动时间规格配置出错，视为启动完成
    if startup_time < STARTUP_TIME_INTERVAL then
        return 'Completed'
    end
    -- 启动时间规格小于等于当前系统时间加上启动时间间隔，认为启动完成
    if startup_time <= uptime + STARTUP_TIME_INTERVAL then
        return 'Completed'
    end

    return 'Starting'
end

return m